# Отчет по работе с Git

## Цель работы
Освоить базовые операции работы с системой контроля версий Git.

## Выполненные действия

### 1. Настройка Git
- Настроены глобальные параметры пользователя
- Проверена конфигурация

### 2. Создание локального репозитория
- Инициализирован репозиторий командой `git init`
- Созданы файлы проекта

### 3. Операция Commit
- Выполнено добавление файлов в staging area (`git add`)
- Созданы коммиты с осмысленными сообщениями

### 4. Работа с ветками
- Созданы ветки: `feature/new-feature` и `hotfix/bug-fix`
- Выполнено переключение между ветками

### 5. Слияние веток
- Выполнено слияние ветки исправлений в основную ветку
- Выполнено слияние ветки функциональности

### 6. Работа с GitHub
- Создан удаленный репозиторий на GitHub
- Выполнена привязка локального и удаленного репозиториев
- Выполнена отправка коммитов (`git push`)
- Выполнено клонирование репозитория (`git clone`)

## Выводы
Освоены базовые операции работы с Git, включая создание репозитория, работу с ветками и слияние изменений.

## Используемые команды
```bash
git init
git add
git commit
git branch
git checkout
git merge
git remote
git push
git clone
